/*****
 * ShellInterfaceExec.c
 *
 *	Interface routines for the adaexec program
 *
 *****/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include "ExecMain.h"
#include "ExecShellGlobals.h"
#include "ExecShellInterface.h"

#include "DrawTextColumn.h"
#include "MacAdalib.h"
#include "AdaFileTypes.h"
#include "TermEmulationIntf.h"
#include "FileMgr.h"
#include "VersStr.h"
#include "config.h"
#include <time.h>

#include <string.h>
#include <stdio.h>

enum	{
	appleID = 1,
	fileID
	};

enum	{
	pauseItem = 1,
	resumeItem = 2,
	quitItem = 4,
	
	aboutItem = 1
	};



/****
 * SetUpMenus()
 *
 *	Set up the menus. Normally, wed use a resource file, but
 *	for this example well supply hardwired strings.
 *
 ****/

void SetUpMenus(void)

{
	InsertMenu(gAppleMenu = NewMenu(appleID, "\p\024"), 0);
	InsertMenu(gFileMenu = NewMenu(fileID, "\pFile"), 0);
	DrawMenuBar();
	AppendMenu(gAppleMenu, "\pAbout adaexec");
	AddResMenu(gAppleMenu, 'DRVR');
	AppendMenu(gFileMenu, "\pPause/P;Resume/R;(-;Quit/Q");
}
/* end SetUpMenus */


/****
 *  AdjustMenus()
 ****/

static void enable (MenuHandle menu, short item, short ok);

void AdjustMenus(void)
{
	enable(gFileMenu, quitItem, 1);
	
	switch (ApplicationState()) {
		case applPaused:
			enable(gFileMenu, resumeItem, 1);
			enable(gFileMenu, pauseItem, 0);
			break;
		case applRunning:
			enable(gFileMenu, resumeItem, 0);
			enable(gFileMenu, pauseItem, 1);
			break;
		case applFinished:
			enable(gFileMenu, resumeItem, 0);
			enable(gFileMenu, pauseItem, 0);
			break;
	}
}


static void enable(MenuHandle menu, short item, short ok)
{
	if (ok)
		EnableItem(menu, item);
	else
		DisableItem(menu, item);
}


/*****
 * HandleMenu(mSelect)
 *
 *	Handle the menu selection. mSelect is what MenuSelect() and
 *	MenuKey() return: the high word is the menu ID, the low word
 *	is the menu item
 *
 *****/

void HandleMenu (long mSelect)

{
	int			menuID = HiWord(mSelect);
	int			menuItem = LoWord(mSelect);
	Str255		name;
	GrafPtr		savePort;
	
	switch (menuID) {

		case appleID:
			switch (menuItem) {
				case aboutItem:
					Alert(20100, NULL);
					break;

				default:
					GetPort(&savePort);
					GetItem(gAppleMenu, menuItem, name);
					OpenDeskAcc(name);
					SetPort(savePort);
					break;
			}
			break;
	
		case fileID:
			switch (menuItem) {
				case pauseItem:
					PauseApplication();
					break;
				case resumeItem:
					ResumeApplication();
					break;
				case quitItem:
					QuitApplication();
					break;
			}
			break;		
	}
}
/* end HandleMenu */


/****
 * SetUpWindow()
 *
 *	Create the window, and open it.
 *
 ****/


void SetUpWindow(void)
{
	Str255 file;
	FILE *fp;

	gShellWindow = scrCreateWindow(monaco, 9, 25, 80);

	FileType('TEXT');
	GetConsoleOutputFile(file);
	fp = fopen(PtoCstr(file), "w");
	if (fp) {
		char *s;
		time_t bintim;
		char *day, *month, *date, *clock, *year;
		Str255 version, unit;

		time(&bintim);
		s = ctime(&bintim);
		day = s;
		s += 3;
		*s++ = '\0';
		month = s;
		s += 3;
		*s++ = '\0';
		date = s;
		s += 2;
		*s++ = '\0';
		clock = s;
		s += 8;
		*s++ = '\0';
		year = s;
		s += 4;
		*s = '\0';

		GetUnitName(unit);
		GetVersStr(version);
		fprintf(fp, "GWU/NYU Adaexec %#s %s  %s  %s %s %s  %s\n",
			version, OP_SYS, day, date, month, year, clock);
		fprintf(fp, "Console Output from \"%#s\"\n\n", unit);
	}


	scrCopyToFile(fp);
}

/****
 *	FinishWindow()
 *
 ****/

void FinishWindow(void)
{
	scrCopyToFile(NULL);
}


/*****
 * DrawWContents()
 *****/
 
void DrawWContents(short active)
{
	scrDrawScreen();
}


/* InternalError() - display alert message, write error results
 * to results file, and call the longjmp.  This routine never
 * returns!
 */

void InternalError(ErrMsgs msgs, int errCode, char *file, int line)
{
	Str255 filename;
	FILE *fp;
	Str255 str[4];
	short i;

	// Setup parameters
	for (i = 0; i < 4; i++) {
		if (msgs[i].id > 0)
			GetIndString(str[i], 128, msgs[i].id);

		else if (msgs[i].msg == NULL)
			str[i][0] = 0;			// NULL Pascal string

		else {
			short len = strlen(msgs[i].msg);
			BlockMove(msgs[i].msg, &str[i][1], len);
			str[i][0] = len;
		}			
	}

	// Show error message.
	ParamText(str[0], str[1], str[2], str[3]);
	InitCursor();
	StopAlert(128, NULL);


	// Now handle writting the errors to the return file
	GetReturnFile(filename);
	PtoCstr(filename);

	fp = fopen((char *)&filename, "w");
	if (fp) {
		fprintf(fp, "Chaos: in %s, line %d\n", file, line);
		fprintf(fp, "Error: %ld\n", (long)errCode);
		fclose(fp);
	}

	// jump back to the main program passing whatever return
	// code we have here!
	longjmp(gJumpEnv, errCode+10);		// add 10, see note in ShellMain.c
}

